/*	
	N-Rage`s Dinput8 Plugin -- V1.80a (23. 1. 2002)
    (C) 2002  Norbert Wladyka

	Author`s Email: norbert.wladyka@chello.at
	Website: http://go.to/nrage


    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef _NRAGEPLUGIN_
#define _NRAGEPLUGIN_

#include <dinput.h>
#include "datatype.h"

//#define ENABLE_PAK_READS_WRITES_DEBUG
//#define ENABLE_GET_STATUS_DEBUG
//#define ENABLE_TPAK_READS_WRITES_DEBUG

/////////////////////////////////////////////////////////////////////////////////
//General Plugin

#define	STRING_PLUGINNAME "N-Rage`s Direct-Input8 V2"

#define PLUGINERROR "N-Rage Plugin Error!"
#define PLUGINMESSAGE "N-Rage Plugin Message"
#define PLUGINWARNING "N-Rage Plugin Warning"

#define TIMER_MESSAGEWINDOW	123

#define MAX_DEVICES		16 // maximum number of devices

#define DEFAULT_STICKRANGE		66
#define DEFAULT_DEADZONE		5
#define DEFAULT_RUMBLETYP		RUMBLE_EFF1
#define DEFAULT_RUMBLESTRENGTH	80
#define DEFAULT_MOUSESENSIVITY	100
#define DEFAULT_PAKTYPE			PAK_NONE

#define PAK_NONE		0
#define PAK_MEM			1
#define PAK_RUMBLE		2
#define PAK_TRANSFER	3
#define PAK_VOICE		4
#define PAK_ADAPTOID	7

#define PAK_NONRAW		16 // just used to display text in GUI



typedef union _BYTEFLAGS
{
	BYTE bValue;
	struct
	{
		unsigned fFlag0			:1;
		unsigned fFlag1			:1;
		unsigned fFlag2			:1;
		unsigned fFlag3			:1;
		unsigned fFlag4			:1;
		unsigned fFlag5			:1;
		unsigned fFlag6			:1;
		unsigned fFlag7			:1;
	};

} BYTEFLAGS, *LPBYTEFLAGS;

typedef struct _EMULATOR_INFO
{
	bool fInitialisedPlugin;
	HWND hMainWindow;
	HINSTANCE hinst;

	BOOL MemoryBswaped;		// If this is set to TRUE, then the memory has been pre
							//   bswap on a dword (32 bits) boundry, only effects header. 
							//	eg. the first 8 bytes are stored like this:
							//        4 3 2 1   8 7 6 5
	BYTE * HEADER;			// This is the rom header (first 40h bytes of the rom)
	CONTROL *Controls;		// A pointer to an array of 4 controllers .. eg:
							// CONTROL Controls[4];
} EMULATOR_INFO, *LPEMULATOR_INFO;

typedef struct _DEVICE
{
	TCHAR szProductName[MAX_PATH];
	BYTE bProductCounter;
	GUID guidInstance;
	DWORD dwDevType;
	BYTE bEffType;
} DEVICE, *LPDEVICE;


typedef union _BUTTON
{
	UINT32 dwButton;
	struct
	{
		BYTE bFlags;
		BYTE bOffset;
		BYTE bAxisID;
		BYTE bType;
	};
	struct
	{
		unsigned fToggleModifier	:1;
		unsigned					:5;
		unsigned fModifierState		:1;
		unsigned fPrevPressed		:1;
	};
} BUTTON, *LPBUTTON;

typedef struct _MODIFIER
{
	BUTTON btnButton;
	BYTE bTyp;
	BOOL fToggle;
	BOOL fStatus;
	BOOL fSHandling;
	DWORD32 dwSpecific;

} MODIFIER, *LPMODIFIER;

// bTyp
#define MDT_NONE		0
#define MDT_MOVE		1
#define MDT_MACRO		2
#define MDT_CONFIG		3
	
#define PF_AXESETS				2 // Number of Analog Stick Configurations

typedef struct _CONTROLLER
{
	unsigned fPlugged			:1;
	unsigned fRawData			:1;
	unsigned fIsAdaptoid		:1;

	unsigned fKeyboard			:1;
	unsigned fMouse				:1;
	unsigned fGamePad			:1;

	unsigned fRealN64Range		:1;
	unsigned bAxisSet			:2;
	unsigned fAbsoluteMouseX	:1;
	unsigned fAbsoluteMouseY	:1;
	unsigned fKeyAbsoluteX		:1;
	unsigned fKeyAbsoluteY		:1;

	unsigned fPakInitialized	:1;
	unsigned fPakCRCError		:1;
	unsigned PakType			:3;
	unsigned bRumbleTyp			:8;
	unsigned fVisualRumble		:1;

	GUID guidPadDevice;
	DWORD dwDevType;

	BYTE bStickRange;

	long lMouseAxes[3];
	WORD wAxeBuffer[4]; // makes pseudo-relative Movement possible

	WORD wMouseSensitivity;
	BYTE bPadDeadZone;
	BYTE bRumbleStrength;
	BYTE nModifiers;

	bool bRapidFireEnabled;
	BYTE bRapidFireRate;
	BYTE bRapidFireCounter;

	TCHAR szMempakFile[MAX_PATH+1];		// MemPak-FileName
	TCHAR szTransferRom[MAX_PATH+1];	// GameBoyRom-Filename
	TCHAR szTransferSave[MAX_PATH+1];	// GameBoyEEPRom-Filename

	BUTTON aButton[14+PF_AXESETS*4];
	DIJOYSTATE jsPadData;				// PadData

	MODIFIER *pModifiers;				// Array of Modifiers

	void *pPakData;						// Pointer to Pak Data (specific)
	

} CONTROLLER, *LPCONTROLLER;

// This is the Index of WORD PROFILE.Button[X]
#define PF_DPADR	0  // Buttons
#define PF_DPADL	1
#define PF_DPADD	2
#define PF_DPADU	3
#define PF_START	4
#define PF_TRIGGERZ	5
#define PF_BBUTTON	6
#define PF_ABUTTON	7 
#define PF_CBUTTONR 8
#define PF_CBUTTONL	9
#define PF_CBUTTOND 10
#define PF_CBUTTONU 11
#define PF_TRIGGERR	12
#define PF_TRIGGERL	13
//#define PF_RESERVED1 14
//#define PF_RESERVED2 15

#define PF_APADR	14 // Analog Stick
#define PF_APADL	15 // cause u can assing Buttons to it
#define PF_APADD	16 // I need 4 of em
#define PF_APADU	17

// #define PF_APADR	18 // second Set
// #define PF_APADL	19
// #define PF_APADD	20
// #define PF_APADU	21




// Thats the Data-Format of DWORD Controller.Button:
//
// BYTE[3] = Determines the Device and general Type of Control
// BYTE[2] = AxeIndentifier, Tells which range of the Axe/POV is important
// BYTE[1] = Offset in the Data Structure
// BYTE[0] = StatusFlags

// BYTE[3] = Determines the Device and general Type of Control
#define DT_BYTE	3 

#define DT_UNASSIGNED		0
#define DT_JOYBUTTON		1 // Joystick
#define DT_JOYAXE			2
#define DT_JOYPOV			3
#define DT_JOYSLIDER		4

#define DT_KEYBUTTON		5 // Keyboard

#define DT_MOUSEBUTTON		6 // Mouse
#define DT_MOUSEAXE			7

// BYTE[2] = AxeIndentifier, Tells which range of the Axe/POV is important
#define AI_BYTE	2

#define AI_AXE_P		0 // Positive Range of an Axe 
#define AI_AXE_N		1 // Negative Range

#define AI_POV_UP		0 // Applys to POVS obviously
#define AI_POV_RIGHT	1
#define AI_POV_DOWN		2
#define AI_POV_LEFT		3

// BYTE[1] = Offset in the Data Structure

// BYTE[0] = StatusFlags
//
// 8|7|0|0|0|0|0|1
//
// 1 = ModifierTyp( 0 = must be applied each time | 1 = only on StatusChange )
// 
// 7 = ModStatus( 0 = inactive | 1 = active )
// 8 = previously pressed


typedef union _MODSPEC_MOVE
{
	DWORD dwValue;
	struct
	{ 
		INT16 XModification;
		INT16 YModification;
	};
} MODSPEC_MOVE, *LPMODSPEC_MOVE;

typedef union _MODSPEC_MACRO
{
	DWORD dwValue;
	struct
	{ 
		UINT16 aButtons;
		UINT16 aFlags;
	};
	struct
	{
		unsigned fDigitalRight	:1;
		unsigned fDigitalLeft	:1;
		unsigned fDigitalDown	:1;
		unsigned fDigitalUp		:1;
		unsigned fStart			:1;
		unsigned fTriggerZ		:1;
		unsigned fBButton		:1;
		unsigned fAButton		:1;
		unsigned fCRight		:1;
		unsigned fCLeft			:1;
		unsigned fCDown			:1;
		unsigned fCUp			:1;
		unsigned fTriggerR		:1;
		unsigned fTriggerL		:1;
		unsigned				:2;

		unsigned fAnalogRight	:1;
		unsigned fAnalogLeft	:1;
		unsigned fAnalogDown	:1;
		unsigned fAnalogUp		:1;
		unsigned fRapidFire		:1;
		unsigned fRapidFireRate	:1;
		unsigned fPrevFireState	:1;
		unsigned fPrevFireState2	:1;
	};
} MODSPEC_MACRO, *LPMODSPEC_MACRO;

typedef union _MODSPEC_CONFIG
{
	DWORD dwValue;
	struct
	{ 
		BYTE bAnalogStick;
		BYTE bMouse;
		BYTE bKeyBoard;
	};
	struct
	{
		unsigned fChangeAnalogConfig	:1;
		unsigned fAnalogStickMode		:7;
		unsigned fChangeMouseXAxis		:1;
		unsigned fChangeMouseYAxis		:1;
		unsigned						:6;
		unsigned fChangeKeyBoardXAxis	:1;
		unsigned fChangeKeyBoardYAxis	:1;
		unsigned						:6;

	};
} MODSPEC_CONFIG, *LPMODSPEC_CONFIG;



typedef struct _SHORTCUTSPL
{
	BYTE bNoPak;
	BYTE bMemPak;
	BYTE bRumblePak;
	BYTE bTransferPak;
	BYTE bVoicePak;
	BYTE bAdaptoidPak;
	BYTE bSwMemRumble;
	BYTE bSwMemAdaptoid;
} SHORTCUTSPL, *LPSHORTCUTSPL;

typedef struct _SHORTCUTS
{
	SHORTCUTSPL Player[4];
	BYTE bMouseLock;
} SHORTCUTS, *LPSHORTCUTS;

#define CHECK_WHITESPACES( str ) ( str == '\r' || str == '\n' || str == '\t' )
	

extern HANDLE g_hHeap;
extern HMODULE g_hDirectInputDLL;
extern HINSTANCE g_hinstDll;
extern SHORTCUTS g_scShortcuts;
extern EMULATOR_INFO g_strEmuInfo;
extern DEVICE g_devList[MAX_DEVICES];
extern CONTROLLER g_pcControllers[4];
extern CRITICAL_SECTION g_resController;
extern bool g_bRunning;

extern bool g_bConfiguring;
extern bool g_bExclusiveMouse;
extern int g_iFirstController;

int FindDeviceinList( TCHAR *pszProductName, BYTE bProductCounter, bool fFindSimilar );
void freeControllerStruct( CONTROLLER *pcController );
void NotifyEmulator();
bool ErrorMessage( TCHAR *pszFirstLine, DWORD dwError, bool fUserChoose );

#endif